/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.dom;

import jp.gr.xml.relax.dom.IDOMVisitor;
import jp.gr.xml.relax.dom.UDOMVisitor;
import jp.gr.xml.relax.xml.UXML;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLMaker
implements IDOMVisitor {
    protected StringBuffer buffer_ = new StringBuffer();
    protected String encoding_ = "UTF-8";
    protected boolean dom2_ = false;
    protected boolean expandEntityReference_ = false;
    protected boolean emptyElementTag_ = false;

    public void setEncoding(String encoding) {
        this.encoding_ = encoding;
    }

    public void setDOM2(boolean dom2) {
        this.dom2_ = dom2;
    }

    public void setExpandEntityReference(boolean expand) {
        this.expandEntityReference_ = expand;
    }

    public void setEmptyElementTag(boolean empty) {
        this.emptyElementTag_ = empty;
    }

    public String getText() {
        return new String(this.buffer_);
    }

    public boolean enter(Element element) {
        String tag = element.getTagName();
        this.buffer_.append("<");
        this.buffer_.append(tag);
        NamedNodeMap attrs = element.getAttributes();
        int nAttrs = attrs.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getSpecified()) continue;
            this.buffer_.append(' ');
            this.enter(attr);
            this.leave(attr);
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Element element) {
        String tag = element.getTagName();
        this.buffer_.append("</" + tag + ">");
    }

    public boolean enter(Attr attr) {
        this.buffer_.append(attr.getName());
        this.buffer_.append("=\"");
        this.buffer_.append(UXML.escapeAttrQuot(attr.getValue()));
        this.buffer_.append('\"');
        return true;
    }

    public void leave(Attr attr) {
    }

    public boolean enter(Text text) {
        this.buffer_.append(UXML.escapeCharData(text.getData()));
        return true;
    }

    public void leave(Text text) {
    }

    public boolean enter(CDATASection cdata) {
        this.buffer_.append("<![CDATA[");
        this.buffer_.append(cdata.getData());
        this.buffer_.append("]]>");
        return true;
    }

    public void leave(CDATASection cdata) {
    }

    public boolean enter(EntityReference entityRef) {
        this.buffer_.append("&");
        this.buffer_.append(entityRef.getNodeName());
        this.buffer_.append(";");
        return false;
    }

    public void leave(EntityReference entityRef) {
    }

    public boolean enter(Entity entity) {
        String name = entity.getNodeName();
        String pid = entity.getPublicId();
        String sid = entity.getSystemId();
        String notation = entity.getNotationName();
        this.buffer_.append("<!ENTITY ");
        this.buffer_.append(name);
        if (sid != null) {
            if (pid != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(pid);
                this.buffer_.append("\" \"");
                this.buffer_.append(UXML.escapeSystemQuot(sid));
                this.buffer_.append("\">");
            } else {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(UXML.escapeSystemQuot(sid));
                this.buffer_.append("\">");
            }
            if (notation != null) {
                this.buffer_.append(" NDATA ");
                this.buffer_.append(notation);
                this.buffer_.append(">");
            }
        } else {
            this.buffer_.append(" \"");
            XMLMaker entityMaker = new XMLMaker();
            UDOMVisitor.traverseChildren(entity, entityMaker);
            this.buffer_.append(UXML.escapeEntityQuot(entityMaker.getText()));
            this.buffer_.append("\"");
            this.buffer_.append(">");
        }
        return false;
    }

    public void leave(Entity entity) {
    }

    public boolean enter(ProcessingInstruction pi) {
        this.buffer_.append("<?");
        this.buffer_.append(pi.getTarget());
        this.buffer_.append(" ");
        this.buffer_.append(pi.getData());
        this.buffer_.append("?>");
        return true;
    }

    public void leave(ProcessingInstruction pi) {
    }

    public boolean enter(Comment comment) {
        this.buffer_.append("<!--");
        this.buffer_.append(comment.getData());
        this.buffer_.append("-->");
        return true;
    }

    public void leave(Comment comment) {
    }

    public boolean enter(Document doc) {
        this.buffer_.append("<?xml version=\"1.0\" encoding=\"");
        this.buffer_.append(this.encoding_);
        this.buffer_.append("\" ?>\n");
        return true;
    }

    public void leave(Document doc) {
    }

    public boolean enter(DocumentType doctype) {
        if (this.dom2_) {
            String name = doctype.getName();
            String publicId = doctype.getPublicId();
            String systemId = doctype.getSystemId();
            String internalSubset = doctype.getInternalSubset();
            this.buffer_.append("<!DOCTYPE ");
            this.buffer_.append(name);
            if (publicId != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(publicId);
                this.buffer_.append("\"");
            }
            if (systemId != null) {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(systemId);
                this.buffer_.append("\"");
            }
            if (internalSubset != null) {
                this.buffer_.append(" [");
                this.buffer_.append(internalSubset);
                this.buffer_.append("]");
            }
            this.buffer_.append(">\n");
            return true;
        }
        String name = doctype.getName();
        NamedNodeMap entities = doctype.getEntities();
        NamedNodeMap notations = doctype.getNotations();
        this.buffer_.append("<!DOCTYPE ");
        this.buffer_.append(name);
        if (entities != null && entities.getLength() > 0 || notations != null && notations.getLength() > 0) {
            this.buffer_.append(" [");
            int nEntities = entities.getLength();
            for (int i = 0; i < nEntities; ++i) {
                XMLMaker entityMaker = new XMLMaker();
                UDOMVisitor.traverse(entities.item(i), entityMaker);
                this.buffer_.append(entityMaker.getText());
            }
            int nNotations = notations.getLength();
            for (int i = 0; i < nNotations; ++i) {
                this.enter((Notation)notations.item(i));
                this.leave((Notation)notations.item(i));
            }
            this.buffer_.append("]");
        }
        this.buffer_.append(">\n");
        return true;
    }

    public void leave(DocumentType doctype) {
    }

    public boolean enter(DocumentFragment docfrag) {
        return true;
    }

    public void leave(DocumentFragment docfrag) {
    }

    public boolean enter(Notation notation) {
        String name = notation.getNodeName();
        String pid = notation.getPublicId();
        String sid = notation.getSystemId();
        this.buffer_.append("<!NOTATION ");
        this.buffer_.append(name);
        if (pid != null) {
            this.buffer_.append(" PUBLIC \"");
            this.buffer_.append(pid);
            this.buffer_.append("\"");
            if (sid != null) {
                this.buffer_.append(" \"");
                this.buffer_.append(UXML.escapeSystemQuot(sid));
                this.buffer_.append("\"");
            }
        } else if (sid != null) {
            this.buffer_.append(" SYSTEM \"");
            this.buffer_.append(UXML.escapeSystemQuot(sid));
            this.buffer_.append("\"");
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Notation notation) {
    }

    public boolean enter(Node node) {
        throw new InternalError(node.toString());
    }

    public void leave(Node node) {
        throw new InternalError(node.toString());
    }

    public boolean isParsedEntity(EntityReference entityRef) {
        String name = entityRef.getNodeName();
        Document doc = entityRef.getOwnerDocument();
        DocumentType doctype = doc.getDoctype();
        if (doctype == null) {
            return false;
        }
        NamedNodeMap entities = doctype.getEntities();
        Entity entity = (Entity)entities.getNamedItem(name);
        if (entity == null) {
            return false;
        }
        return entity.getNotationName() == null;
    }
}

